/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

void main(void)
{
	vec2 o = vec2(iResolution.x/2.0, iResolution.y*0.9);
	vec2 d = vec2(0.0, -1.0);
	vec2 uv = gl_FragCoord.xy;
	vec3 col = vec3(0.0);
	for (int i=0; i<100; i++) {
		vec4 tex = texture2D(iChannel0, vec2(float(i)/256.0, iGlobalTime), -100.0);
		vec2 tgt = vec2(iResolution.x/2.0, iResolution.y*0.1)-o;
		vec2 seek = normalize(tgt)*(16.0/(length(tgt)+1.0));
		d = normalize(seek+vec2(1.5, -1.0)*(vec2(-0.5, 0.0)+tex.gb));
		float len = min(length(tgt), 9.0 * (tex.r+0.1));
		float dist = abs(dot(o-uv, d.yx*vec2(1.0,-1.0)));
		o += d*len;
		if (dist < 1.5 && length(o-uv) < len*0.75) {
			col = vec3(1.0);
			break;
		}
	}
	gl_FragColor = vec4(col, 1.0);
}